 ; Ŀ
 ;   Px - move text into the correct position relative to a block.         
 ;   Copyright 1995, 1997, 2000, 2002, 2005, 2010 by Rocket Software Ltd.  
 ;                                                                         
 ; 

 ; Ŀ
 ;   Cron - returns the corners of a text entity.                          
 ;   Arguments: Enam, a text entity ename.                                 
 ;              Offdis, the offset distance.                               
 ;   Rewritten 2010.10.10.                                                 
 ; 
 (DEFUN CRON (enam offdis / aa bb rota cc dd bheigt bwidth llangg lldist ll ul
                                                    lr ur xmax xmin ymax ymin)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
 ; Ŀ
 ;   Extract the real corner points of the text.                           
 ; 
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Find the maximum and minimum X and Y points.  These may not be the    
 ;   same as the corners of the text box, since the text may be rotated.   
 ; 
  (setq xmax (max (car ul) (car ll) (car ur) (car lr)))
  (setq xmin (min (car ul) (car ll) (car ur) (car lr)))
  (setq ymax (max (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq ymin (min (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq xmax (+ xmax offdis))
  (setq xmin (- xmin offdis))
  (setq ymax (+ ymax offdis))
  (setq ymin (- ymin offdis))
 ; Ŀ
 ;   And return the max and min x and y list.                              
 ; 
 (list xmax xmin ymax ymin))
 ; Ŀ
 ;   Cron end.                                                             
 ; 

 ; Ŀ
 ;   Grout - Text/Attdef grdraw outliner.                                  
 ;   Arguments: SS, a selection set of textlike things.                    
 ;              Gbox, the grdraw colour, if nil then don't draw a box.     
 ;              Offdis, the offset distance for text.                      
 ;   Returns a list of four corner points, cw from top left.               
 ;   Rewritten 2010.10.10 to take Offdis as an argument.                   
 ; 
 (DEFUN GROUT (ss gbox offdis / num enam typ entt mxlst xmax xmin ymax ymin
                                                                ul ur lr ll)
  (setq num 0)
 ; Ŀ
 ;   Process selection set.                                                
 ; 
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (itoa (setq num (1+ num))))
         (setq typ (cdr (assoc 0 (entget enam))))
         (if (= typ "INSERT")
             (while (/= (setq typ (cdr (assoc 0 (setq entt (entget
                                                (setq enam (entnext enam)))))))
                        "SEQEND")
                    (if (and (= typ "ATTRIB")
                             (/= (cdr (assoc 1 entt)) "")
                             (/= (cdr (assoc 1 entt)) " "))
                        (progn
                             (setq mxlst (cron enam offdis))
                             (if xmax
                                 (setq xmax (max xmax (car mxlst)))
                                 (setq xmax (car mxlst)))
                             (if xmin
                                 (setq xmin (min xmin (cadr mxlst)))
                                 (setq xmin (cadr mxlst)))
                             (if ymax
                                 (setq ymax (max ymax (caddr mxlst)))
                                 (setq ymax (caddr mxlst)))
                             (if ymin
                                 (setq ymin (min ymin (cadddr mxlst)))
                                 (setq ymin (cadddr mxlst)))))))
         (if (or (= typ "TEXT") (= typ "ATTDEF"))
             (progn
                  (setq mxlst (cron enam 0))
                  (if xmax
                      (setq xmax (max xmax (car mxlst)))
                      (setq xmax (car mxlst)))
                  (if xmin
                      (setq xmin (min xmin (cadr mxlst)))
                      (setq xmin (cadr mxlst)))
                  (if ymax
                      (setq ymax (max ymax (caddr mxlst)))
                      (setq ymax (caddr mxlst)))
                  (if ymin
                      (setq ymin (min ymin (cadddr mxlst)))
                      (setq ymin (cadddr mxlst))))))
 ; Ŀ
 ;   Make the corner point coordinates.                                    
 ; 
  (setq ul (list xmin ymax))
  (setq ur (list xmax ymax))
  (setq lr (list xmax ymin))
  (setq ll (list xmin ymin))
 ; Ŀ
 ;   Now draw the polyline around the outer extent points.                 
 ; 
  (if gbox
      (progn
           (grdraw ul ur gbox)
           (grdraw ur lr gbox)
           (grdraw lr ll gbox)
           (grdraw ll ul gbox)))
 (list ul ur lr ll))
 ; Ŀ
 ;   Grout end.                                                            
 ; 

 ; Ŀ
 ;   Sidle: MR or ML rejustify text, respace it vertically, reposition it  
 ;   horizontally and vertically.                                          
 ;   Arguments: Pa, a point.                                               
 ;              SS, a selection set of text.                               
 ;              Rorl, "r" or "l" rejustification.                          
 ;   Calls Grout, Vbmr, Vvbs.                                              
 ;   Returns nothing.                                                      
 ; 
 (DEFUN SIDLE (pa ss rorl / incr ptlist curtop curbot curvc)
 ; Ŀ
 ;   Find the line spacing.                                                
 ; 
  (setq incr (* 1.65 (cdr (assoc 40 (entget (ssname ss 0))))))
 ; Ŀ
 ;   Get the text ss corner points, don't outline the text.                
 ; 
  (setq ptlist (grout ss nil (* 0.5 (misps))))
 ; Ŀ
 ;   Middle right or left rejustify the text.                              
 ; 
  (if (= rorl "r")
      (vbmr ss pa)
      (vbml ss pa))
 ; Ŀ
 ;   And vertically respace it.                                            
 ; 
  (if (> (sslength ss) 1)
      (vvbs ss (cadr pa) incr))
 ; Ŀ
 ;   Save the new text ss corner points, again don't outline it.           
 ; 
  (setq ptlst (grout ss nil (* 0.5 (misps))))
 ; Ŀ
 ;   Now calculate the current vertical centre of the text ss and move it  
 ;   to the desired vertical centre, pa.                                   
 ; 
  (setq curtop (cadr (nth 0 ptlst)))
  (setq curbot (cadr (nth 2 ptlst)))
  (setq curvc (/ (+ curtop curbot) 2))
  (command ".move" ss "" (list 0 curvc) (list 0 (cadr pa)))
 (princ))
 ; Ŀ
 ;   Sidle end.                                                            
 ; 

 ; Ŀ
 ;   VBCX - centre rejustify a column of text.                             
 ;   Takes two arguments - an ss and a centre point x coordinate.          
 ;   Returns zilch.                                                        
 ; 
 (DEFUN VBCX (ss xa / num enam entt pty pa)
  (setq xa (car xa))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq pty (cddr (assoc 10 entt)))
         (setq pa (cons xa pty))
         (setq entt (subst (cons 72 1) (assoc 72 entt) entt))
         (if (= typ "ATTDEF")
             (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
             (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
         (entmod (subst (cons 11 pa) (assoc 11 entt) entt)))
 (princ))
 ; Ŀ
 ;   Vbcx end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Vbml - middle left rejustify a column of text.             
 ;   Arguments: ss, a selection set.                                       
 ;              Pa, a right point.                                         
 ;   Calls nothing, Returns nothing.                                       
 ; 
 (DEFUN VBML (ss xa / num enam entt typ pta pa pta1 p11 ydis new11 sp)
  (setq xa (car xa))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq typ (cdr (assoc 0 entt)))
         (setq pta (cdr (assoc 10 entt)))
         (setq pa (cons xa (cdr pta)))
         (if (= typ "TEXT")
             (if (assoc 73 entt)
                 (setq entt (subst (cons 73 2) (assoc 73 entt) entt))
                 (setq entt (append entt (list (cons 73 2)))))
             (if (assoc 74 entt)
                 (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
                 (setq entt (append entt (list (cons 74 2))))))
         (setq entt (subst (cons 72 0) (assoc 72 entt) entt))
         (entmod (subst (cons 11 pa) (assoc 11 entt) entt))
         (setq entt (entget enam))
         (setq pta1 (cdr (assoc 10 entt)))
         (setq p11 (cdr (assoc 11 entt)))
         (setq ydis (- (cadr pta) (cadr pta1)))
         (setq new11 (list (car p11) (+ (cadr p11) ydis) (caddr p11)))
         (entmod (subst (cons 11 new11) (assoc 11 entt) entt)))
 (princ))
 ; Ŀ
 ;   Subroutine Vbml end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Vbmr - middle right rejustify a column of text.            
 ;   Arguments: ss, a selection set.                                       
 ;              Pa, a right point.                                         
 ;   Calls nothing, Returns nothing.                                       
 ; 
 (DEFUN VBMR (ss xa / num enam entt typ pta pa pta1 p11 ydis new11 sp)
  (setq xa (car xa))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq typ (cdr (assoc 0 entt)))
         (setq pta (cdr (assoc 10 entt)))
         (setq pa (cons xa (cdr pta)))
         (if (= typ "TEXT")
             (if (assoc 73 entt)
                 (setq entt (subst (cons 73 2) (assoc 73 entt) entt))
                 (setq entt (append entt (list (cons 73 2)))))
             (if (assoc 74 entt)
                 (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
                 (setq entt (append entt (list (cons 74 2))))))
         (setq entt (subst (cons 72 2) (assoc 72 entt) entt))
         (entmod (subst (cons 11 pa) (assoc 11 entt) entt))
         (setq entt (entget enam))
         (setq pta1 (cdr (assoc 10 entt)))
         (setq p11 (cdr (assoc 11 entt)))
         (setq ydis (- (cadr pta) (cadr pta1)))
         (setq new11 (list (car p11) (+ (cadr p11) ydis) (caddr p11)))
         (entmod (subst (cons 11 new11) (assoc 11 entt) entt)))
 (princ))
 ; Ŀ
 ;   Subroutine Vbmr end.                                                  
 ; 

 ; Ŀ
 ;   Vbup: centre rejustify and vertically respace text either above or    
 ;   below a point.                                                        
 ;   Arguments: Pa, a point.                                               
 ;              SS, a selection set of text.                               
 ;              Uord, "u" or "d" arrangement.                              
 ;   If Uord is u then the text is positioned so that the bottom of the    
 ;   lowest text entity is on pa.                                          
 ;   If Uord is d then the text is positioned so that the top of the       
 ;   highest text entity is on pa.                                         
 ;   Calls Grout and Vvbs.                                                 
 ;   Returns nothing.                                                      
 ; 
 (DEFUN VBUP (pa ss uord / incr orlst ptext)
 ; Ŀ
 ;   Find the line spacing.                                                
 ; 
  (setq incr (* 1.65 (setq txht (cdr (assoc 40 (entget (ssname ss 0)))))))
 ; Ŀ
 ;   Centre rejustify the text.                                            
 ; 
  (vbcx ss pa)
 ; Ŀ
 ;   And vertically respace it.                                            
 ; 
  (setq orlst (vvbs ss (cadr pa) incr))
 ; Ŀ
 ;   Move it to the right location.                                        
 ; 
  (if (= uord "u")
      (progn
           (setq ptext (cdr (assoc 11 (entget (last orlst)))))
           (command ".move" ss "" ptext pa))
      (progn
           (setq ptext (cdr (assoc 11 (entget (car orlst)))))
           (setq pa (polar pa (* pi 1.5) txht))
           (command ".move" ss "" ptext pa)))
 (princ))
 ; Ŀ
 ;   Vbup end.                                                             
 ; 

 ; Ŀ
 ;   VVBS - vertically respace a column of text.                           
 ;   Arguments: Ss - a selection set of text and attdefs.                  
 ;              Yins - the centre point y coordinate.                      
 ;              Incr - the vertical spacing.                               
 ;   Returns a list of the entity names in vertical order.                 
 ; 
 (DEFUN VVBS (ss yins incr / sss num txa enn nna ya txb yb txh yy nn yins orls)
 ; Ŀ
 ;   Make a copy of the ss so as not to destroy the original.              
 ; 
  (setq sss (ssadd))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (ssadd enam sss))
 ; Ŀ
 ;   Process the new sss.                                                  
 ; 
  (while (setq txa (ssname sss 0))             ; first entity name
         (setq enn 1)                         ; entity to test - initialize
         (setq nna (entget txa))              ; the whole thing
         (setq ya (cdr (assoc 10 nna)))       ; Y insertion
 ; Ŀ
 ;   Find the highest entity.                                              
 ; 
         (while (setq txb (ssname sss enn))                 ; next entity
                (setq yb (cdr (assoc 10 (entget txb))))    ; Y insertion
                (if (> (cadr yb) (cadr ya))                ; if txb highest
                    (progn
                         (setq txa txb)                    ; next becomes txa
                         (setq nna (entget txa))           ; get whole thing
                         (setq ya (cdr (assoc 10 nna)))))  ; and Y insertion
                (setq enn (1+ enn)))                       ; next entity
 ; Ŀ
 ;   And move it.                                                          
 ; 
         (if (or (= (cdr (assoc 72 nna)) 2)
                 (= (cdr (assoc 72 nna)) 4)
                 (= (cdr (assoc 72 nna)) 1))
             (progn
                   (if (= (cdr (assoc 72 nna)) 4)
                       (progn
                             (setq txh (cdr (assoc 40
                                                   (entget (ssname sss 0)))))
                             (setq yy (cdr (assoc 11 nna)))
                             (setq nn (list (car yy) (+ (/ txh 2) yins)))
                             (command "move" txa "" yy nn))
                       (progn
                             (setq yy (cdr (assoc 11 nna)))
                             (setq nn (list (car yy) yins))
                             (command "move" txa "" yy nn))))
             (progn
                   (setq yy (cdr (assoc 10 nna)))
                   (setq nn (list (car yy) yins))
                   (command "move" txa "" yy nn)))
 ; Ŀ
 ;   Increment the insertion point, add the entity name Txa to the         
 ;   ordered list, remove the entity from sss, loop.                       
 ; 
         (setq yins (- yins incr))
         (setq orls (cons txa orls))
         (ssdel txa sss))
 (reverse orls))
 ; Ŀ
 ;   Vvbs end.                                                             
 ; 

 ; Ŀ
 ;   Px.                                                                   
 ; 
 (DEFUN C:PX (/ osmo snapp orth *error* ss num enam typ blent blpa brot pa pb
                                                                  txang gnupt)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq orth (getvar "orthomode"))
  (setvar "orthomode" 0)
 ; Ŀ
 ;   Make an error handler.  Errors will be added later.                   
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (setvar "osmode" osmo)
   (setvar "orthomode" orth)
   (command "undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get an ss of text or block insertions.                                
 ; 
  (prompt "Pick text to rearrange, and a block: ")
  (if (setq ss (ssget '((-4 . "<or")
                        (0 . "text")
                        (0 . "insert")
                        (-4 . "or>"))))
      (progn
 ; Ŀ
 ;   Separate out the first block (there should only be one) and the text. 
 ; 
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq typ (cdr (assoc 0 (entget enam))))
                  (cond ((= typ "TEXT")
                         (setq num (1+ num)))
                        ((= typ "INSERT")
                         (if (null blent)
                             (setq blent enam))
                         (ssdel enam ss))))
 ; Ŀ
 ;   Get the block insertion point and rotation angle.                     
 ; 
           (setq blent (entget blent))
           (setq blpa (cdr (assoc 10 blent)))
           (setq brot (cdr (assoc 50 blent)))
 ; Ŀ
 ;   Get the centre point of the block of text.                            
 ; 
           (setq pa (grout ss nil (* 0.5 (misps))))
           (setq pb (last pa))
           (setq pa (car pa))
           (setq pa (list (/ (+ (car pa) (car pb)) 2)
                          (/ (+ (cadr pa) (cadr pb)) 2)))
 ; Ŀ
 ;   Find where the text is in relation to the block.                      
 ; 
           (setq txang (angle blpa pa))
 ; Ŀ
 ;   The block is either horizontal or vertical and the text is either     
 ;   above or below, and right or left, respectively.                      
 ;   1. The block is more horizontal than vertical.                        
 ; 
           (cond ((or (and (>= brot (* pi 0.75))
                           (< brot  (* pi 1.25)))
                      (< brot (* pi 0.25))
                      (>= brot (* pi 0.875)))
 ; Ŀ
 ;   1a. The text overall centrepoint is more or less above the block.     
 ; 
                  (if (and (>= txang 0)
                           (< txang pi))
                      (progn
                           (setq gnupt (polar blpa (* pi 0.5) 3))
                           (vbup gnupt ss "u"))
 ; Ŀ
 ;   1b. The text overall centrepoint is more or less to the lright.       
 ; 
                      (progn
                           (setq gnupt (polar blpa (* pi 1.5) 3))
                           (vbup gnupt ss "d"))))
 ; Ŀ
 ;   2. The block is more vertical than horizontal.                        
 ; 
                 (t
 ; Ŀ
 ;   2a. The text overall centrepoint is more or less to the left.         
 ; 
                  (if (and (>= txang (* pi 0.5))
                           (< txang  (* pi 1.5)))
                      (progn
                           (setq gnupt (polar blpa pi 3))
                           (sidle gnupt ss "r"))
 ; Ŀ
 ;   2b. The text overall centrepoint is more or less to the lright.       
 ; 
                      (progn
                           (setq gnupt (polar blpa 0 3))
                           (sidle gnupt ss "l")))))))
 ; Ŀ
 ;   End quietly, unless something went wrong.                             
 ; 
  (*error* ())
 (princ))